<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:xhtml="http://www.w3.org/TR/xhtml/strict"
    	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
		xmlns:aid="http://ns.adobe.com/AdobeInDesign/4.0/"
		xmlns:aid5="http://ns.adobe.com/AdobeInDesign/5.0/"
		xmlns:tei="http://www.tei-c.org/ns/1.0"
		xmlns="http://www.tei-c.org/ns/1.0"		
		exclude-result-prefixes="tei xhtml"
>
<xsl:output method="xml" encoding="UTF-8" indent="no"/>

<xsl:strip-space elements="*"/>

<xsl:param name="directory"/>
<xsl:param name="fileName"/>

<xsl:template match="@*|node()">
  <xsl:copy>
    <xsl:apply-templates select="@*|node()"/>
  </xsl:copy>
</xsl:template>

<xsl:template match="/">
	<xsl:result-document href="{concat($directory,'/.notes/typeNote_',$fileName)}" method="xml">
	<TEI 
      xmlns="http://www.tei-c.org/ns/1.0"
      xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
      xmlns:xs="http://www.w3.org/2001/XMLSchema"
      xmlns:xinclude="http://www.w3.org/2001/XInclude"
      xmlns:ns="http://www.tei-c.org/ns/1.0"
      xmlns:hfp="http://www.w3.org/2001/XMLSchema-hasFacetAndProperty"
      xmlns:aid5="http://ns.adobe.com/AdobeInDesign/5.0/"
      xmlns:aid="http://ns.adobe.com/AdobeInDesign/4.0/">
      <teiHeader>
        <fileDesc>
          <titleStmt>
            <title>Types de notes dans <xsl:value-of select="$fileName"/></title>
          </titleStmt>
          <publicationStmt>
            <p></p>
          </publicationStmt>
          <sourceDesc>
            <bibl>Référence bibliographique à la source</bibl>
          </sourceDesc>
        </fileDesc>
        <encodingDesc>
          <projectDesc>
            <p>Informations sur l'encodage.</p>
          </projectDesc>
        </encodingDesc>
        <revisionDesc>
          <change when="2015" who="réviseur">Liste des types de notes</change>
        </revisionDesc>
      </teiHeader>
      <text xml:id="text">
      	<front>
      		<titlePage>
      			<titlePart type="main">
      				Liste des types de notes dans <xsl:value-of select="$fileName"/>
      			</titlePart>
      		</titlePage>
      	</front>
        <body>
        	<xsl:for-each-group select="//tei:note[@type!='standard']/@type" group-by=".">
          		<div>
                   	<xsl:apply-templates select="."/>
                   	<p><xsl:value-of select="."/></p>
                </div>
            </xsl:for-each-group>
        </body>
      </text>
    </TEI>
  </xsl:result-document>
  <!--  <xsl:for-each-group select="//tei:note[@type!='standard']/@type" group-by=".">
		<xsl:apply-templates select="."/><xsl:text>
</xsl:text>
	</xsl:for-each-group>-->
</xsl:template>

</xsl:stylesheet>

