<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
           xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" encoding="UTF-8" indent="yes"/>

    <xsl:param name="newProvenance" />

	<xsl:template match="@*|node()">
		<xsl:copy>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:copy>
	</xsl:template>
	
	<xsl:template match="*:domaine">
		<xsl:copy>
			<xsl:apply-templates />
			<xsl:if test="count(tokenize($newProvenance, '\|'))=2 and *:name=substring-before($newProvenance, '|')">
				<entite>
					<name><xsl:value-of select="substring-after($newProvenance, '|')"/></name>
				</entite>
			</xsl:if>			
		</xsl:copy>
		<xsl:if test="not(contains($newProvenance, '|')) and not(following-sibling::*:domaine)">
			<domaine>
				<name><xsl:value-of select="$newProvenance"/></name>
			</domaine>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="*:entite">
		<xsl:copy>
			<xsl:apply-templates />
			<xsl:if test="count(tokenize($newProvenance, '\|'))=3 and ancestor::*:domaine/*:name=substring-before($newProvenance, '|') and *:name=substring-before(substring-after($newProvenance, '|'), '|')">
				<emetteur>
					<name><xsl:value-of select="substring-after(substring-after($newProvenance, '|'), '|')"/></name>
				</emetteur>
			</xsl:if>
		</xsl:copy>
	</xsl:template>
	
           
</xsl:stylesheet>