<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
           xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text" encoding="UTF-8" indent="no"/>

    <xsl:param name="currentInfos" />

	<xsl:template match="/">
		<xsl:text>(-- Nouvelle entrée --)&#10;</xsl:text>
		<xsl:text>?&#10;</xsl:text>
		<xsl:choose>
			<xsl:when test="$currentInfos=''">
				<xsl:for-each select="//*:domaine/*:name">
                	<xsl:value-of select="." /><xsl:text>&#10;</xsl:text>
            	</xsl:for-each>
			</xsl:when>
			<xsl:when test="$currentInfos!='' and not(contains($currentInfos, '|'))">
				<xsl:for-each select="//*:domaine[*:name=$currentInfos]/*:entite/*:name">
                	<xsl:value-of select="." /><xsl:text>&#10;</xsl:text>
            	</xsl:for-each>				
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="currentDomNum" select="substring-before($currentInfos, '|')"/>
				<xsl:variable name="currentEntPol" select="substring-after($currentInfos, '|')"/>
				<xsl:for-each select="//*:domaine[*:name=$currentDomNum]/*:entite[*:name=$currentEntPol]/*:emetteur/*:name">
                	<xsl:value-of select="." /><xsl:text>&#10;</xsl:text>
            	</xsl:for-each>	
			</xsl:otherwise>
		</xsl:choose>
    </xsl:template>
           
</xsl:stylesheet>