<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xhtml="http://www.w3.org/TR/xhtml/strict"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:tei="http://www.tei-c.org/ns/1.0"
	xmlns:xinclude="http://www.w3.org/2001/XInclude"
	xmlns:xlink="http://www.w3.org/1999/xlink"
   	xmlns="http://www.xmlmind.com/xmleditor/schema/configuration"
	exclude-result-prefixes="tei xhtml">

<xsl:output method="text" encoding="UTF-8" omit-xml-declaration="yes" indent="no"/> 


<xsl:template match="/">

	<!--<xsl:text>Commune&#09;</xsl:text>-->
	<xsl:text>Lieu-dit&#09;</xsl:text>
	<xsl:text>Département&#09;</xsl:text>
	<xsl:text>Coordonnées géographiques&#09;</xsl:text>
	<xsl:text>Propriétaire du terrain&#09;</xsl:text>
	<xsl:text>Type de site&#09;</xsl:text>
	<xsl:text>Datation du site&#09;</xsl:text>
	<xsl:text>Circonstance de découverte&#09;</xsl:text>
	<xsl:text>Inventeur&#09;</xsl:text>
	<xsl:text>Date de la découverte&#09;</xsl:text>
	<xsl:text>Commentaire libre sur la composition du trésor&#09;</xsl:text>
	<xsl:text>Institution de conservation&#09;</xsl:text>
	<xsl:text>Cote dans l'institution de conservation&#09;</xsl:text>
	<xsl:text>Précision localisation&#09;</xsl:text>
	<xsl:text>Trouvaille Références typologiques&#09;</xsl:text>
	<xsl:text>Situation zone&#09;</xsl:text>
	<xsl:text>Numéro US&#09;</xsl:text>
	<xsl:text>Nature de l'activité&#09;</xsl:text>
	<xsl:text>Contexte archéologique immédiat&#09;</xsl:text>
	<xsl:text>Datation du contexte archéologique immédiat&#09;</xsl:text>
	<xsl:text>Phase du site&#09;</xsl:text>
	<xsl:text>Nature de la découverte&#09;</xsl:text>
	<xsl:text>Commentaire sur la nature de la découverte&#09;</xsl:text>
	<xsl:text>Contenant&#09;</xsl:text>
	<xsl:text>État de la trouvaille&#09;</xsl:text>
	<xsl:text>Nombre d'objets numismatiques&#09;</xsl:text>
	<xsl:text>Matériaux représentés&#09;</xsl:text>
	<xsl:text>Date de la monnaie récente&#09;</xsl:text>
	<xsl:text>Date de la monnaie ancienne&#09;</xsl:text>
	<xsl:text>Liste sommaire du contenu&#09;</xsl:text>
	<xsl:text>Qualité de l'information numismatique&#09;</xsl:text>
	<xsl:text>Numéro de l'inventaire&#09;</xsl:text>
	<xsl:text>Ensemble monétaire&#09;</xsl:text>
	<xsl:text>Type d'objet&#09;</xsl:text>
	<xsl:text>Matériau&#09;</xsl:text>
	<xsl:text>Légende (droit)&#09;</xsl:text>
	<xsl:text>Champ (droit)&#09;</xsl:text>
	<xsl:text>Légende (revers)&#09;</xsl:text>
	<xsl:text>Champ (revers)&#09;</xsl:text>
	<xsl:text>Lettres dans le champ&#09;</xsl:text>
	<xsl:text>Différent d'atelier&#09;</xsl:text>
	<xsl:text>Millésime&#09;</xsl:text>
	<xsl:text>Contremarque&#09;</xsl:text>
	<xsl:text>Mode de fabrication&#09;</xsl:text>
	<xsl:text>Commentaire frappe&#09;</xsl:text>
	<xsl:text>Modifications, mutilations&#09;</xsl:text>
	<xsl:text>État de conservation&#09;</xsl:text>
	<xsl:text>Usure&#09;</xsl:text>
	<xsl:text>Corrosion&#09;</xsl:text>
	<xsl:text>Diamètre&#09;</xsl:text>
	<xsl:text>Poids&#09;</xsl:text>
	<xsl:text>Axe&#09;</xsl:text>
	<xsl:text>Domaine numismatique&#09;</xsl:text>
	<xsl:text>Entité politique&#09;</xsl:text>
	<xsl:text>Émetteur&#09;</xsl:text>
	<xsl:text>Dénomination&#09;</xsl:text>
	<xsl:text>Production&#09;</xsl:text>
	<xsl:text>Atelier&#09;</xsl:text>
	<xsl:text>Date d'émission&#09;</xsl:text>
	<xsl:text>Nom générique du type&#09;</xsl:text>
	<xsl:text>Référence typologique&#09;</xsl:text>
	<xsl:text>Méthode d'analyse&#09;</xsl:text>
	<xsl:text>Conditions d'analyse&#09;</xsl:text>
	<xsl:text>Date d'analyse&#09;</xsl:text>
	<xsl:text>Nom, auteur et institution de rattachement&#09;</xsl:text>
	<xsl:text>Métal/élément chimique&#09;</xsl:text>
	<xsl:text>Proportion&#09;</xsl:text>
	<xsl:text>&#13;</xsl:text>

    <xsl:for-each-group select="//tei:div[@type='site_archeo']/tei:msDesc/tei:msIdentifier/tei:settlement" group-by="text()">
    	<xsl:value-of select="."/>
    		<xsl:text>&#13;</xsl:text>
    <xsl:for-each select="//tei:div[@type='monnaie']">
    <!--<xsl:if test="ancestor-or-self::tei:div[@type='site_archeo']/tei:msDesc/tei:msIdentifier/tei:settlement !='-'"><xsl:value-of select="ancestor-or-self::tei:div[@type='site_archeo']/tei:msDesc/tei:msIdentifier/tei:settlement"/></xsl:if><xsl:text>&#09;</xsl:text>-->
    <xsl:if test="ancestor-or-self::tei:div[@type='site_archeo']/tei:msDesc/tei:msIdentifier/tei:geogName !='-'"><xsl:value-of select="ancestor-or-self::tei:div[@type='site_archeo']/tei:msDesc/tei:msIdentifier/tei:geogName"/></xsl:if><xsl:text>&#09;</xsl:text>
    <xsl:if test="ancestor-or-self::tei:div[@type='site_archeo']/tei:msDesc/tei:msIdentifier/tei:district !='-'"><xsl:value-of select="ancestor-or-self::tei:div[@type='site_archeo']/tei:msDesc/tei:msIdentifier/tei:district"/></xsl:if><xsl:text>&#09;</xsl:text>
    <xsl:if test="ancestor-or-self::tei:div[@type='site_archeo']/tei:msDesc/tei:history/tei:provenance/tei:listPlace/tei:place/tei:location/tei:geo !='-'"><xsl:value-of select="ancestor-or-self::tei:div[@type='site_archeo']/tei:msDesc/tei:history/tei:provenance/tei:listPlace/tei:place/tei:location/tei:geo"/></xsl:if><xsl:text>&#09;</xsl:text>
    <xsl:if test="ancestor-or-self::tei:div[@type='site_archeo']/tei:msDesc/tei:history/tei:provenance/tei:listPerson/tei:person[@role='landowner'] !='-'"><xsl:value-of select="ancestor-or-self::tei:div[@type='site_archeo']/tei:msDesc/tei:history/tei:provenance/tei:listPerson/tei:person[@role='landowner']"/></xsl:if><xsl:text>&#09;</xsl:text>
    <xsl:if test="ancestor-or-self::tei:div[@type='site_archeo']/tei:msDesc/tei:history/tei:provenance/tei:listPlace/tei:place/state[@type='archaeological_site_type'] !='-'"><xsl:value-of select="ancestor-or-self::tei:div[@type='site_archeo']/tei:msDesc/tei:history/tei:provenance/tei:listPlace/tei:place/state[@type='archaeological_site_type']"/></xsl:if><xsl:text>&#09;</xsl:text>
    <xsl:if test="ancestor-or-self::tei:div[@type='site_archeo']/tei:msDesc/tei:history/tei:provenance/tei:listPlace/tei:place/state[@type='datation'] !='-'"><xsl:value-of select="ancestor-or-self::tei:div[@type='site_archeo']/tei:msDesc/tei:history/tei:provenance/tei:listPlace/tei:place/state[@type='datation']"/></xsl:if><xsl:text>&#09;</xsl:text>
    <xsl:if test="ancestor::tei:div[@type='Trouvaille']/tei:msDesc/tei:history/tei:acquisition/tei:p !='-'"><xsl:value-of select="ancestor::tei:div[@type='Trouvaille']/tei:msDesc/tei:history/tei:acquisition/tei:p"/></xsl:if><xsl:text>&#09;</xsl:text>
    <xsl:if test="ancestor::tei:div[@type='Trouvaille']/tei:msDesc/tei:history/tei:provenance/tei:listPerson/tei:person[@role='inventeur']/tei:persName !='-'"><xsl:value-of select="ancestor::tei:div[@type='Trouvaille']/tei:msDesc/tei:history/tei:provenance/tei:listPerson/tei:person[@role='inventeur']/tei:persName"/></xsl:if><xsl:text>&#09;</xsl:text>
    <xsl:if test="ancestor::tei:div[@type='Trouvaille']/tei:msDesc/tei:history/tei:provenance[@type='found']/tei:date[@type='date_decouverte'] !='-'"><xsl:value-of select="ancestor::tei:div[@type='Trouvaille']/tei:msDesc/tei:history/tei:provenance[@type='found']/tei:date[@type='date_decouverte']"/></xsl:if><xsl:text>&#09;</xsl:text>
    <xsl:if test="ancestor::tei:div[@type='Trouvaille']/tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:support/tei:p !='-'"><xsl:value-of select="ancestor::tei:div[@type='Trouvaille']/tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:support/tei:p"/></xsl:if><xsl:text>&#09;</xsl:text>
    <xsl:if test="ancestor::tei:div[@type='Trouvaille']/tei:msDesc/tei:msIdentifier/tei:repository !='-'"><xsl:value-of select="ancestor::tei:div[@type='Trouvaille']/tei:msDesc/tei:msIdentifier/tei:repository"/></xsl:if><xsl:text>&#09;</xsl:text>
    <xsl:if test="ancestor::tei:div[@type='Trouvaille']/tei:msDesc/tei:msIdentifier/tei:idno[@type='Cote_institution'] !='-'"><xsl:value-of select="ancestor::tei:div[@type='Trouvaille']/tei:msDesc/tei:msIdentifier/tei:idno[@type='Cote_institution']"/></xsl:if><xsl:text>&#09;</xsl:text>
    <xsl:if test="ancestor::tei:div[@type='Trouvaille']/tei:msDesc/tei:history/tei:provenance/tei:listPlace/tei:place/tei:placeName[@type='localisation'] !='-'"><xsl:value-of select="ancestor::tei:div[@type='Trouvaille']/tei:msDesc/tei:history/tei:provenance/tei:listPlace/tei:place/tei:placeName[@type='localisation']"/></xsl:if><xsl:text>&#09;</xsl:text>
    <xsl:if test="ancestor::tei:div[@type='Trouvaille']/tei:msDesc/tei:additional/tei:listBibl[@type='Bibliographie']/tei:bibl !='-'"><xsl:value-of select="ancestor::tei:div[@type='Trouvaille']/tei:msDesc/tei:additional/tei:listBibl[@type='Bibliographie']/tei:bibl"/></xsl:if><xsl:text>&#09;</xsl:text>
    <xsl:if test="preceding-sibling::tei:msDesc/tei:msIdentifier/tei:settlement[@type='Situation_zone'] !='-'"><xsl:value-of select="preceding-sibling::tei:msDesc/tei:msIdentifier/tei:settlement[@type='Situation_zone']"/></xsl:if><xsl:text>&#09;</xsl:text>
    <xsl:if test="preceding-sibling::tei:msDesc/tei:msIdentifier/tei:idno[@type='Numero_US'] !='-'"><xsl:value-of select="preceding-sibling::tei:msDesc/tei:msIdentifier/tei:idno[@type='Numero_US']"/></xsl:if><xsl:text>&#09;</xsl:text>
    <xsl:if test="preceding-sibling::tei:msDesc/tei:history/tei:provenance/tei:listPlace/tei:place/tei:state[@type='nature_activite']/tei:p !='-'"><xsl:value-of select="preceding-sibling::tei:msDesc/tei:history/tei:provenance/tei:listPlace/tei:place/tei:state[@type='nature_activite']/tei:p"/></xsl:if><xsl:text>&#09;</xsl:text>
    <xsl:if test="preceding-sibling::tei:msDesc/tei:history/tei:provenance/tei:listPlace/tei:place/tei:state[@type='immediat_context']/tei:p !='-'"><xsl:value-of select="preceding-sibling::tei:msDesc/tei:history/tei:provenance/tei:listPlace/tei:place/tei:state[@type='immediat_context']/tei:p"/></xsl:if><xsl:text>&#09;</xsl:text>
    <xsl:if test="preceding-sibling::tei:msDesc/tei:history/tei:provenance/tei:date[@type='periode_decouverte']/tei:p !='-'"><xsl:value-of select="preceding-sibling::tei:msDesc/tei:history/tei:provenance/tei:date[@type='periode_decouverte']"/></xsl:if><xsl:text>&#09;</xsl:text>
    <xsl:if test="preceding-sibling::tei:msDesc/tei:history/tei:provenance/tei:listPlace/tei:place/tei:state[@type='phase_site']/tei:p !='-'"><xsl:value-of select="preceding-sibling::tei:msDesc/tei:history/tei:provenance/tei:listPlace/tei:place/tei:state[@type='phase_site']/tei:p"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="preceding-sibling::tei:msDesc/tei:physDesc/tei:p/tei:objectType/tei:interp[@type='nature_decouverte'] !='-'"><xsl:value-of select="preceding-sibling::tei:msDesc/tei:physDesc/tei:p/tei:objectType/tei:interp[@type='nature_decouverte']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="preceding-sibling::tei:msDesc/tei:physDesc/tei:p/tei:objectType/tei:interp[@type='commentaire_nature'] !='-'"><xsl:value-of select="preceding-sibling::tei:msDesc/tei:physDesc/tei:p/tei:objectType/tei:interp[@type='commentaire_nature']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="preceding-sibling::tei:msDesc/tei:physDesc/tei:accMat[@type='container'] !='-'"><xsl:value-of select="preceding-sibling::tei:msDesc/tei:physDesc/tei:accMat[@type='container']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="preceding-sibling::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:condition/tei:state[@type='etat_trouvaille']/tei:p !='-'"><xsl:value-of select="preceding-sibling::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:condition/tei:state[@type='etat_trouvaille']/tei:p"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="preceding-sibling::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:extent/tei:measure[@type='nombre_objects']/tei:material !='-'"><xsl:value-of select="preceding-sibling::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:extent/tei:measure[@type='nombre_objects']/tei:material"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="preceding-sibling::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:extent/tei:measure[@type='materiaux_representes']/tei:material !='-'"><xsl:value-of select="preceding-sibling::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:extent/tei:measure[@type='materiaux_representes']/tei:material"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="preceding-sibling::tei:msDesc/tei:msContents/tei:msItem/tei:p/tei:date[@type='recente'] !='-'"><xsl:value-of select="preceding-sibling::tei:msDesc/tei:msContents/tei:msItem/tei:p/tei:date[@type='recente']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="preceding-sibling::tei:msDesc/tei:msContents/tei:msItem/tei:p/tei:date[@type='ancienne'] !='-'"><xsl:value-of select="preceding-sibling::tei:msDesc/tei:msContents/tei:msItem/tei:p/tei:date[@type='ancienne']"/></xsl:if><xsl:text>&#09;</xsl:text>
    <xsl:if test="preceding-sibling::tei:msDesc/tei:msContents/tei:summary/tei:list/tei:item !='-'"><xsl:value-of select="preceding-sibling::tei:msDesc/tei:msContents/tei:summary/tei:list/tei:item"/></xsl:if><xsl:text>&#09;</xsl:text>   
    <xsl:if test="preceding-sibling::tei:msDesc/tei:msContents/tei:msItem/tei:p/tei:note[@type='qualite_info_numis'] !='-'"><xsl:value-of select="preceding-sibling::tei:msDesc/tei:msContents/tei:msItem/tei:p/tei:note[@type='qualite_info_numis']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:msIdentifier/tei:idno[@type='inventaire'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:msIdentifier/tei:idno[@type='inventaire']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:p/tei:objectType/tei:interp[type='ensemble_monetaire'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:p/tei:objectType/tei:interp[type='ensemble_monetaire']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:p/tei:objectType/tei:interp[type='type_objet'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:p/tei:objectType/tei:interp[type='type_objet']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:support/tei:measure[@type='materiau']/tei:material !='-'"><xsl:value-of select="descendant::tei:msIdentifier/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:support/tei:measure[@type='materiau']/tei:material"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:decoDesc/tei:decoNote[@type='legende_droit'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:decoDesc/tei:decoNote[@type='legende_droit']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:decoDesc/tei:decoNote[@type='champ_droit'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:decoDesc/tei:decoNote[@type='champ_droit']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:decoDesc/tei:decoNote[@type='legende_revers'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:decoDesc/tei:decoNote[@type='legende_revers']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:decoDesc/tei:decoNote[@type='champ_revers'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:decoDesc/tei:decoNote[@type='champ_revers']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:decoDesc/tei:decoNote[@type='lettres_champ'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:decoDesc/tei:decoNote[@type='lettres_champ']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:decoDesc/tei:decoNote[@type='different_atelier'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:decoDesc/tei:decoNote[@type='different_atelier']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:support/tei:num[@type='millesime'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:support/tei:num[@type='millesime']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:support/tei:term[@type='contremarque']/tei:ref[@target] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:support/tei:term[@type='contremarque']/tei:ref[@target]"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:support/tei:term[@type='fabrication'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:support/tei:term[@type='fabrication']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:p/tei:objectType/tei:interp[@type='commentaire_frappe'] !='-'"><xsl:value-of select="descendant::tei:msDesc//tei:physDesc/tei:p/tei:objectType/tei:interp[@type='commentaire_frappe']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:condition/tei:mod[@type='modification'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:condition/tei:mod[@type='modification']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:condition/tei:state[@type='etat_conservation']/tei:p !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:condition/tei:state[@type='etat_conservation']/tei:p"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:condition/tei:mod[@type='usure'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:condition/tei:mod[@type='usure']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:condition/tei:mod[@type='corrosion'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:condition/tei:mod[@type='corrosion']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:support/tei:dimensions/tei:dim[@type='diametre'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:support/tei:dimensions/tei:dim[@type='diametre']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:support/tei:measure[@type='weight'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:support/tei:measure[@type='weight']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:support/tei:measure[@type='axis'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:support/tei:measure[@type='axis']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:history/tei:provenance/tei:title[@type='Domaine_numismatique'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:history/tei:provenance/tei:title[@type='Domaine_numismatique']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:history/tei:provenance/tei:title[@type='entite_politique'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:history/tei:provenance/tei:title[@type='entite_politique']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:history/tei:provenance/tei:listPerson/tei:person[@role='issuer']/tei:persName !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:history/tei:provenance/tei:listPerson/tei:person[@role='issuer']/tei:persName"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:history/tei:provenance/tei:title[@type='denomination'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:history/tei:provenance/tei:title[@type='denomination']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:history/tei:provenance/tei:title[@type='production'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:history/tei:provenance/tei:title[@type='production']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:history/tei:provenance/tei:listPlace/tei:place/tei:placeName[@type='Atelier'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:history/tei:provenance/tei:listPlace/tei:place/tei:placeName[@type='Atelier']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:history/tei:acquisition/tei:p/place/tei:date[@type='Date_emission'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:history/tei:acquisition/tei:p/place/tei:date[@type='Date_emission']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:history/tei:provenance/tei:title[@type='nom_generique'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:history/tei:provenance/tei:title[@type='nom_generique']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:history/tei:provenance/tei:listBibl[@type='References_typologiques']/tei:bibl !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:history/tei:provenance/tei:listBibl[@type='References_typologiques']/tei:bibl"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:condition/tei:state[@type='methode_analyse']/tei:p !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:condition/tei:state[@type='methode_analyse']/tei:p"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:condition/tei:state[@type='conditions_analyse']/tei:p !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:condition/tei:state[@type='conditions_analyse']/tei:p"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:condition/tei:date[@type='analyse'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:condition/tei:date[@type='analyse']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/./tei:msIdentifier/tei:settlement !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:msIdentifier/tei:settlement"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:decoDesc/tei:decoNote[@type='Metal_element_chimique'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:decoDesc/tei:decoNote[@type='Metal_element_chimique']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:support/tei:measure[@type='Proportion'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:support/tei:measure[@type='Proportion']"/></xsl:if><xsl:text>&#09;</xsl:text>

	<xsl:text>
</xsl:text>

	</xsl:for-each>
	
	

</xsl:for-each-group>
</xsl:template>

</xsl:stylesheet>