<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xhtml="http://www.w3.org/TR/xhtml/strict"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:tei="http://www.tei-c.org/ns/1.0"
	xmlns:xinclude="http://www.w3.org/2001/XInclude"
	xmlns:xlink="http://www.w3.org/1999/xlink"
   	xmlns="http://www.xmlmind.com/xmleditor/schema/configuration"
	exclude-result-prefixes="tei xhtml">

<xsl:output method="text" encoding="UTF-8" omit-xml-declaration="yes" indent="no"/> 


<xsl:template match="/">


	<xsl:text>Commune&#09;</xsl:text>
	<xsl:text>Lieu-dit&#09;</xsl:text>
	<xsl:text>Département&#09;</xsl:text>
	<xsl:text>Coordonnées géographiques&#09;</xsl:text>
	<xsl:text>Propriétaire du terrain&#09;</xsl:text>
	<xsl:text>Type de site&#09;</xsl:text>
	<xsl:text>Datation du site&#09;</xsl:text>
	<xsl:text>Circonstance de découverte&#09;</xsl:text>
	<xsl:text>Inventeur&#09;</xsl:text>
	<xsl:text>Département&#09;</xsl:text>
	<xsl:text>Date de la découverte&#09;</xsl:text>
	<xsl:text>Commentaire libre sur la composition du trésor&#09;</xsl:text>
	<xsl:text>Institution de conservation&#09;</xsl:text>
	<xsl:text>Cote dans l'institution de conservation&#09;</xsl:text>
	<xsl:text>Précision localisation&#09;</xsl:text>
	<xsl:text>Références typologiques&#09;</xsl:text>
	<xsl:text>Situation zone&#09;</xsl:text>
	<xsl:text>Numéro US&#09;</xsl:text>
	<xsl:text>Nature de l'activité&#09;</xsl:text>
	<xsl:text>Contexte archéologique immédiat&#09;</xsl:text>
	<xsl:text>Datation du contexte archéologique immédiat&#09;</xsl:text>
	<xsl:text>Phase du site&#09;</xsl:text>
	<xsl:text>Nature de la découverte&#09;</xsl:text>
	<xsl:text>Commentaire sur la nature de la découverte&#09;</xsl:text>
	<xsl:text>Contenant&#09;</xsl:text>
	<xsl:text>État de la trouvaille&#09;</xsl:text>
	<xsl:text>Nombre d'objets numismatiques&#09;</xsl:text>
	<xsl:text>Matériaux représentés&#09;</xsl:text>
	<xsl:text>Date de la monnaie récente&#09;</xsl:text>
	<xsl:text>Date de la monnaie ancienne&#09;</xsl:text>
	<xsl:text>Liste sommaire du contenu&#09;</xsl:text>
	<xsl:text>Qualité de l'information numismatique&#09;</xsl:text>
	<xsl:text>Numéro de l'inventaire&#09;</xsl:text>
	<xsl:text>Ensemble monétaire&#09;</xsl:text>
	<xsl:text>Type d'objet&#09;</xsl:text>
	<xsl:text>Matériau&#09;</xsl:text>
	<xsl:text>Légende (droit)&#09;</xsl:text>
	<xsl:text>Champ (droit)&#09;</xsl:text>
	<xsl:text>Légende (revers)&#09;</xsl:text>
	<xsl:text>Champ (revers)&#09;</xsl:text>
	<xsl:text>Lettres dans le champ&#09;</xsl:text>
	<xsl:text>Différent d'atelier&#09;</xsl:text>
	<xsl:text>Millésime&#09;</xsl:text>
	<xsl:text>Contremarque&#09;</xsl:text>
	<xsl:text>Mode de fabrication&#09;</xsl:text>
	<xsl:text>Commentaire frappe&#09;</xsl:text>
	<xsl:text>Modifications, mutilations&#09;</xsl:text>
	<xsl:text>État de conservation&#09;</xsl:text>
	<xsl:text>Usure&#09;</xsl:text>
	<xsl:text>Corrosion&#09;</xsl:text>
	<xsl:text>Diamètre&#09;</xsl:text>
	<xsl:text>Poids&#09;</xsl:text>
	<xsl:text>Axe&#09;</xsl:text>
	<xsl:text>Domaine numismatique&#09;</xsl:text>
	<xsl:text>Entité politique&#09;</xsl:text>
	<xsl:text>Émetteur&#09;</xsl:text>
	<xsl:text>Dénomination&#09;</xsl:text>
	<xsl:text>Production&#09;</xsl:text>
	<xsl:text>Atelier&#09;</xsl:text>
	<xsl:text>Date d'émission&#09;</xsl:text>
	<xsl:text>Nom générique du type&#09;</xsl:text>
	<xsl:text>Référence typologique&#09;</xsl:text>
	<xsl:text>Méthode d'analyse&#09;</xsl:text>
	<xsl:text>Conditions d'analyse&#09;</xsl:text>
	<xsl:text>Date d'analyse&#09;</xsl:text>
	<xsl:text>Nom, auteur et institution de rattachement&#09;</xsl:text>
	<xsl:text>Métal/élément chimique&#09;</xsl:text>
	<xsl:text>Proportion&#09;</xsl:text>
	<xsl:text>&#13;</xsl:text>

    <xsl:for-each-group select="//tei:div[@type='site_archeo']/tei:msDesc/tei:msIdentifier/tei:settlement" group-by="text()">
    	<xsl:value-of select="."/>
    		<xsl:text>&#13;</xsl:text>
    <xsl:for-each select="//tei:div[@type='monnaie']">
	<xsl:if test="descendant::tei:msDesc/tei:msIdentifier/tei:idno[@type='inventaire'] !='-'"><xsl:value-of select="descendant::tei:msIdentifier/tei:idno[@type='inventaire']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:p/tei:objectType/tei:interp[type='ensemble_monetaire'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:p/tei:objectType/tei:interp[type='ensemble_monetaire']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:p/tei:objectType/tei:interp[type='type_objet'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:p/tei:objectType/tei:interp[type='type_objet']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:support/tei:measure[@type='materiau']/tei:material !='-'"><xsl:value-of select="descendant::tei:msIdentifier/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:support/tei:measure[@type='materiau']/tei:material"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:decoDesc/tei:decoNote[@type='legende_droit'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:decoDesc/tei:decoNote[@type='legende_droit']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:decoDesc/tei:decoNote[@type='champ_droit'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:decoDesc/tei:decoNote[@type='champ_droit']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:decoDesc/tei:decoNote[@type='legende_revers'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:decoDesc/tei:decoNote[@type='legende_revers']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:decoDesc/tei:decoNote[@type='champ_revers'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:decoDesc/tei:decoNote[@type='champ_revers']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:decoDesc/tei:decoNote[@type='lettres_champ'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:decoDesc/tei:decoNote[@type='lettres_champ']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:decoDesc/tei:decoNote[@type='different_atelier'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:decoDesc/tei:decoNote[@type='different_atelier']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:support/tei:num[@type='millesime'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:support/tei:num[@type='millesime']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:support/tei:term[@type='contremarque']/tei:ref[@target] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:support/tei:term[@type='contremarque']/tei:ref[@target]"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:support/tei:term[@type='fabrication'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:support/tei:term[@type='fabrication']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:p/tei:objectType/tei:interp[@type='commentaire_frappe'] !='-'"><xsl:value-of select="descendant::tei:msDesc//tei:physDesc/tei:p/tei:objectType/tei:interp[@type='commentaire_frappe']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:condition/tei:mod[@type='modification'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:condition/tei:mod[@type='modification']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:condition/tei:state[@type='etat_conservation']/tei:p !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:condition/tei:state[@type='etat_conservation']/tei:p"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:condition/tei:mod[@type='usure'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:condition/tei:mod[@type='usure']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:condition/tei:mod[@type='corrosion'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:condition/tei:mod[@type='corrosion']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:support/tei:dimensions/tei:dim[@type='diametre'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:support/tei:dimensions/tei:dim[@type='diametre']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:support/tei:measure[@type='weight'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:support/tei:measure[@type='weight']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:support/tei:measure[@type='axis'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:support/tei:measure[@type='axis']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:history/tei:provenance/tei:title[@type='Domaine_numismatique'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:history/tei:provenance/tei:title[@type='Domaine_numismatique']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:history/tei:provenance/tei:title[@type='entite_politique'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:history/tei:provenance/tei:title[@type='entite_politique']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:history/tei:provenance/tei:listPerson/tei:person[@role='issuer']/tei:persName !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:history/tei:provenance/tei:listPerson/tei:person[@role='issuer']/tei:persName"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:history/tei:provenance/tei:title[@type='denomination'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:history/tei:provenance/tei:title[@type='denomination']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:history/tei:provenance/tei:title[@type='production'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:history/tei:provenance/tei:title[@type='production']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:history/tei:provenance/tei:listPlace/tei:place/tei:placeName[@type='Atelier'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:history/tei:provenance/tei:listPlace/tei:place/tei:placeName[@type='Atelier']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:history/tei:acquisition/tei:p/place/tei:date[@type='Date_emission'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:history/tei:acquisition/tei:p/place/tei:date[@type='Date_emission']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:history/tei:provenance/tei:title[@type='nom_generique'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:history/tei:provenance/tei:title[@type='nom_generique']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:history/tei:provenance/tei:listBibl[@type='References_typologiques']/tei:bibl !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:history/tei:provenance/tei:listBibl[@type='References_typologiques']/tei:bibl"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:condition/tei:state[@type='methode_analyse']/tei:p !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:condition/tei:state[@type='methode_analyse']/tei:p"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:condition/tei:state[@type='conditions_analyse']/tei:p !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:condition/tei:state[@type='conditions_analyse']/tei:p"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:condition/tei:date[@type='analyse'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:condition/tei:date[@type='analyse']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/./tei:msIdentifier/tei:settlement !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:msIdentifier/tei:settlement"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:decoDesc/tei:decoNote[@type='Metal_element_chimique'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:decoDesc/tei:decoNote[@type='Metal_element_chimique']"/></xsl:if><xsl:text>&#09;</xsl:text>
	<xsl:if test="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:support/tei:measure[@type='Proportion'] !='-'"><xsl:value-of select="descendant::tei:msDesc/tei:physDesc/tei:objectDesc/tei:supportDesc/tei:support/tei:measure[@type='Proportion']"/></xsl:if><xsl:text>&#09;</xsl:text>

	<xsl:text>
</xsl:text>

	</xsl:for-each>
	
	

</xsl:for-each-group>
</xsl:template>

</xsl:stylesheet>